rollout DYNmrSkyLight ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCobj

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNskyParams FUNsky =
  (
    DYNmrSkyLight.LOCobj = FUNsky

    if classOf FUNsky == mr_Sky then
    (
      DYNmrSkyLight.LBDYNlightName.text       = FUNsky.name + " (mr Sky)"
      DYNmrSkyLight.LOCobj                    = FUNsky
      DYNmrSkyLight.CKDYNskyOn.checked        = FUNsky.on
      DYNmrSkyLight.SPDYNskyMult.value        = FUNsky.multiplier
      DYNmrSkyLight.SPDYNhorHeight.value      = FUNsky.HorizonHeight
      DYNmrSkyLight.SPDYNhorBlur.value        = FUNsky.HorizonBlur
      DYNmrSkyLight.CODYNcolorG.color         = FUNsky.GroundColor
      DYNmrSkyLight.CODYNcolorN.color         = FUNsky.NightColor
      DYNmrSkyLight.CKDYNaerialPersp.checked  = FUNsky.UseAerialPerspective
      DYNmrSkyLight.SPDYNvisibility.value     = FUNsky.AerialPerspective
      DYNmrSkyLight.SPDYNhaze.value           = FUNsky.haze
      DYNmrSkyLight.SPDYNredness.value        = FUNsky.Redness
      DYNmrSkyLight.SPDYNsaturation.value     = FUNsky.Saturation
    )
    else
    (
      for i in DYNmrSkyLight.controls do i.enabled = false
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  label LBDYNlightName align:#center

  groupbox GBDYNgroup00 pos:[4,24] width:(DYNiniExplorerWidth - 21) height:87
  checkbox CKDYNskyOn align:#left pos:[13,45]
  label   LBDYNskyMult  align:#left pos:[13,67]
  spinner  SPDYNskyMult align:#left pos:[(DYNiniExplorerWidth - 96),65] range:[0.0,100000000.,1.0] type:#float   fieldwidth:60 scale:0.01
  label   LBDYNhaze align:#left pos:[13,87]
  spinner  SPDYNhaze align:#left pos:[(DYNiniExplorerWidth - 96),85] range:[0.0,15.0,0.0] type:#float fieldwidth:60 scale:0.1

  groupbox GBDYNgroup01 pos:[4,116] width:(DYNiniExplorerWidth - 21) height:82
  label   LBDYNhorHeight  align:#left pos:[13,136]
  spinner SPDYNhorHeight  align:#left pos:[(DYNiniExplorerWidth - 96),134] range:[-10.0,10.0,1.0] type:#float fieldwidth:60 scale:0.1
  label   LBDYNhorBlur    align:#left pos:[13,156]
  spinner SPDYNhorBlur    align:#left pos:[(DYNiniExplorerWidth - 96),154] range:[0.0,10.0,1.0] type:#float fieldwidth:60 scale:0.1
  label   LBDYNcolorG     align:#left pos:[13,176]
  colorpicker CODYNcolorG "" align:#left pos:[(DYNiniExplorerWidth - 98),174] height:15 width:72

  groupbox GBDYNgroup02 pos:[4,205] width:(DYNiniExplorerWidth - 21) height:43
  label   LBDYNcolorN     align:#left pos:[13,225]
  colorpicker CODYNcolorN "" align:#left pos:[(DYNiniExplorerWidth - 98),223] height:15 width:72

  groupbox GBDYNgroup03 pos:[4,255] width:(DYNiniExplorerWidth - 21) height:60
  label   LBDYNredness    align:#left pos:[13,275]
  spinner SPDYNredness    align:#left pos:[(DYNiniExplorerWidth - 96),273] range:[-1.0,1.0,1.0] type:#float fieldwidth:60 scale:0.01
  label   LBDYNsaturation align:#left pos:[13,295]
  spinner SPDYNsaturation align:#left pos:[(DYNiniExplorerWidth - 96),293] range:[0.0,2.0,1.0] type:#float fieldwidth:60 scale:0.05

  groupbox GBDYNgroup04 pos:[4,322] width:(DYNiniExplorerWidth - 21) height:85
  checkbox CKDYNaerialPersp   align:#left   pos:[13,340]
  label   LBDYNvisibility align:#left pos:[13,360]
  spinner SPDYNvisibility align:#left pos:[(DYNiniExplorerWidth - 189),380] range:[0.0,10000000272564224.0,1.0] type:#worldunits fieldwidth:147 scale:0.01

  on DYNmrSkyLight open do
  (
    DYNmrSkyLight.title   = DYNuiRolloutNames[29]

    GBDYNgroup00.text     = DYNuiResourcesGroups[67]
    GBDYNgroup01.text     = DYNuiResourcesGroups[85]
    GBDYNgroup02.text     = DYNuiResourcesGroups[86]
    GBDYNgroup03.text     = DYNuiResourcesGroups[87]
    GBDYNgroup04.text     = DYNuiResourcesGroups[81]

    CKDYNskyOn.text       = DYNuiResourcesLabels[22]
    CKDYNaerialPersp.text = DYNuiResourcesLabels[22]

    LBDYNhorHeight.text   = DYNuiResourcesLabels[30]
    LBDYNhorBlur.text     = DYNuiResourcesLabels[257]
    LBDYNredness.text     = DYNuiResourcesLabels[258]
    LBDYNsaturation.text  = DYNuiResourcesLabels[259]
    LBDYNhaze.text        = DYNuiResourcesLabels[255]
    LBDYNskyMult.text     = DYNuiResourcesLabels[131]
    LBDYNcolorG.text      = DYNuiResourcesLabels[261]
    LBDYNcolorN.text      = DYNuiResourcesLabels[262]
    LBDYNvisibility.text  = DYNuiResourcesLabels[268]
  )

  on CKDYNskyOn changed arg do
  (
    LOCobj.on = arg
    if DYNLightList.open then
    (
      DYNlightList.DYNFUNupdateLightInstances LOCobj
    )
  )

  on SPDYNskyMult changed arg do LOCobj.multiplier = arg
  on SPDYNskyMult entered do
  (
    if DYNLightList.open then
    (
      DYNlightList.DYNFUNupdateLightInstances LOCobj

      local LOCitem = DYNFUNfindListViewItemByTag DYNlightList.dnLights (LOCobj.inode.handle as string)
      if LOCitem != undefined then LOCitem.SubItems.item[1].text = SPDYNskyMult.value as string
    )
  )

  on CODYNcolorG      changed arg do (LOCobj.GroundColor = arg)
  on CODYNcolorN      changed arg do (LOCobj.NightColor = arg)
  on SPDYNhaze        changed arg do (LOCobj.haze = arg)
  on SPDYNhorHeight   changed arg do (LOCobj.HorizonHeight = arg)
  on SPDYNhorBlur     changed arg do (LOCobj.HorizonBlur = arg)
  on SPDYNvisibility  changed arg do (LOCobj.AerialPerspective = arg)
  on CKDYNaerialPersp changed arg do (LOCobj.UseAerialPerspective = arg)
  on SPDYNsaturation  changed arg do (LOCobj.saturation = arg)
  on SPDYNredness     changed arg do (LOCobj.redness = arg)
)
